-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.sTCounter = 0
    end    
    
    self.sTownHandler:LinkToTarget("sTown")
	  self.sTownHandler:LinkToTarget("sAttackDeact")
    self.sTownHandler:LinkToTarget("sTownReinf")
  end
  
  if self.sTCounter == 3 then
    self.sTownHandler:TriggerAllTargets()
	  self.sTCounter = 0
  end
   
end

function OnTrigger(self, source, target)
  if target == "sTownBuildings" then
    self.sTCounter = self.sTCounter + 1
    Debug:Log("ST counter = " .. self.sTCounter)
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.sTCounter = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.sTCounter)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("sTownBuildings")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("sTownHandler")
end
